<?php
/**
 * Shared Auth Page Styles & Components
 * Professional UI/UX for authentication pages
 */

function renderAuthHead(string $title): void {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?> — Analytics</title>
    <style>
        *, *::before, *::after { margin: 0; padding: 0; box-sizing: border-box; }

        :root {
            --primary: #3b82f6;
            --primary-dark: #1d4ed8;
            --primary-light: #93bbfd;
            --primary-bg: rgba(59, 130, 246, 0.08);
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;
            --success: #10b981;
            --success-bg: rgba(16, 185, 129, 0.08);
            --danger: #ef4444;
            --danger-bg: rgba(239, 68, 68, 0.08);
            --warning: #f59e0b;
            --white: #ffffff;
            --radius-sm: 8px;
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 24px;
            --shadow-sm: 0 1px 2px rgba(0,0,0,0.05);
            --shadow-md: 0 4px 6px -1px rgba(0,0,0,0.07), 0 2px 4px -2px rgba(0,0,0,0.05);
            --shadow-lg: 0 10px 15px -3px rgba(0,0,0,0.08), 0 4px 6px -4px rgba(0,0,0,0.04);
            --shadow-xl: 0 20px 25px -5px rgba(0,0,0,0.08), 0 8px 10px -6px rgba(0,0,0,0.04);
            --transition: 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Inter', Roboto, Helvetica, Arial, sans-serif;
            background: var(--gray-50);
            color: var(--gray-900);
            min-height: 100vh;
            line-height: 1.6;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        /* === AUTH LAYOUT === */
        .auth-wrapper {
            display: flex;
            min-height: 100vh;
        }

        /* Left brand panel */
        .auth-brand {
            display: none;
            flex-direction: column;
            justify-content: center;
            padding: 60px;
            width: 45%;
            background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 50%, #2563eb 100%);
            color: white;
            position: relative;
            overflow: hidden;
        }

        .auth-brand::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(255,255,255,0.08) 0%, transparent 70%);
            border-radius: 50%;
        }

        .auth-brand::after {
            content: '';
            position: absolute;
            bottom: -30%;
            left: -10%;
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, rgba(255,255,255,0.05) 0%, transparent 70%);
            border-radius: 50%;
        }

        .auth-brand-content {
            position: relative;
            z-index: 1;
        }

        .auth-brand h1 {
            font-size: 42px;
            font-weight: 800;
            letter-spacing: -1.5px;
            margin-bottom: 16px;
            line-height: 1.1;
        }

        .auth-brand p {
            font-size: 17px;
            opacity: 0.85;
            line-height: 1.7;
            max-width: 400px;
        }

        .auth-brand-features {
            margin-top: 48px;
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .auth-brand-feature {
            display: flex;
            align-items: center;
            gap: 14px;
            font-size: 15px;
            opacity: 0.9;
        }

        .auth-brand-feature-icon {
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.15);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            flex-shrink: 0;
        }

        /* Right form panel */
        .auth-form-panel {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 40px 24px;
            background: var(--gray-50);
            position: relative;
        }

        .auth-card {
            width: 100%;
            max-width: 440px;
            background: var(--white);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-xl);
            padding: 48px 40px;
            position: relative;
            border: 1px solid var(--gray-100);
        }

        /* Header */
        .auth-header {
            text-align: center;
            margin-bottom: 36px;
        }

        .auth-logo {
            width: 56px;
            height: 56px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border-radius: var(--radius-md);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.25);
        }

        .auth-logo svg {
            width: 28px;
            height: 28px;
            fill: white;
        }

        .auth-header h1 {
            font-size: 26px;
            font-weight: 700;
            color: var(--gray-900);
            letter-spacing: -0.5px;
            margin-bottom: 8px;
        }

        .auth-header p {
            font-size: 14px;
            color: var(--gray-500);
            font-weight: 400;
        }

        /* Form elements */
        .form-group {
            margin-bottom: 22px;
            position: relative;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 14px;
        }

        .form-label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: var(--gray-700);
            margin-bottom: 7px;
            letter-spacing: 0.2px;
        }

        .form-input {
            width: 100%;
            padding: 12px 14px;
            font-size: 14px;
            font-family: inherit;
            color: var(--gray-900);
            background: var(--white);
            border: 1.5px solid var(--gray-200);
            border-radius: var(--radius-sm);
            transition: all var(--transition);
            outline: none;
        }

        .form-input:hover {
            border-color: var(--gray-300);
        }

        .form-input:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.12);
        }

        .form-input::placeholder {
            color: var(--gray-400);
        }

        .form-input.error {
            border-color: var(--danger);
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
        }

        /* Password field */
        .password-wrapper {
            position: relative;
        }

        .password-wrapper .form-input {
            padding-right: 48px;
        }

        .password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            color: var(--gray-400);
            padding: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: color var(--transition);
        }

        .password-toggle:hover {
            color: var(--gray-600);
        }

        .password-toggle svg {
            width: 20px;
            height: 20px;
        }

        /* Password strength */
        .password-strength {
            margin-top: 10px;
        }

        .strength-bar {
            height: 4px;
            background: var(--gray-200);
            border-radius: 4px;
            overflow: hidden;
            margin-bottom: 6px;
        }

        .strength-fill {
            height: 100%;
            border-radius: 4px;
            transition: all 0.4s ease;
            width: 0%;
        }

        .strength-fill.weak { width: 25%; background: var(--danger); }
        .strength-fill.fair { width: 50%; background: var(--warning); }
        .strength-fill.good { width: 75%; background: #22c55e; }
        .strength-fill.strong { width: 100%; background: var(--success); }

        .strength-text {
            font-size: 12px;
            font-weight: 500;
            color: var(--gray-500);
        }

        /* Buttons */
        .btn {
            width: 100%;
            padding: 13px 20px;
            font-size: 14px;
            font-weight: 600;
            font-family: inherit;
            border-radius: var(--radius-sm);
            border: none;
            cursor: pointer;
            transition: all var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            position: relative;
            overflow: hidden;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.25);
        }

        .btn-primary:hover:not(:disabled) {
            transform: translateY(-1px);
            box-shadow: 0 6px 20px rgba(59, 130, 246, 0.35);
        }

        .btn-primary:active:not(:disabled) {
            transform: translateY(0);
        }

        .btn-primary:disabled {
            opacity: 0.65;
            cursor: not-allowed;
            transform: none;
        }

        .btn-outline {
            background: transparent;
            color: var(--primary);
            border: 1.5px solid var(--gray-200);
        }

        .btn-outline:hover {
            border-color: var(--primary);
            background: var(--primary-bg);
        }

        /* Spinner */
        .btn .spinner {
            display: none;
            width: 18px;
            height: 18px;
            border: 2px solid rgba(255,255,255,0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 0.6s linear infinite;
        }

        .btn.loading .spinner {
            display: block;
        }

        .btn.loading .btn-text {
            opacity: 0;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Alerts */
        .alert {
            padding: 14px 16px;
            border-radius: var(--radius-sm);
            font-size: 13px;
            font-weight: 500;
            margin-bottom: 20px;
            display: none;
            align-items: flex-start;
            gap: 10px;
            line-height: 1.5;
        }

        .alert.show {
            display: flex;
        }

        .alert-error {
            background: var(--danger-bg);
            color: var(--danger);
            border: 1px solid rgba(239, 68, 68, 0.15);
        }

        .alert-success {
            background: var(--success-bg);
            color: #047857;
            border: 1px solid rgba(16, 185, 129, 0.15);
        }

        .alert-icon {
            flex-shrink: 0;
            width: 18px;
            height: 18px;
            margin-top: 1px;
        }

        /* Divider */
        .auth-divider {
            display: flex;
            align-items: center;
            margin: 28px 0;
            gap: 16px;
        }

        .auth-divider::before,
        .auth-divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: var(--gray-200);
        }

        .auth-divider span {
            font-size: 12px;
            font-weight: 500;
            color: var(--gray-400);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* Footer link */
        .auth-footer {
            text-align: center;
            margin-top: 28px;
            padding-top: 24px;
            border-top: 1px solid var(--gray-100);
        }

        .auth-footer p {
            font-size: 14px;
            color: var(--gray-500);
        }

        .auth-footer a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            transition: color var(--transition);
        }

        .auth-footer a:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }

        .auth-link {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            font-size: 13px;
            transition: color var(--transition);
        }

        .auth-link:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }

        /* Info box */
        .info-box {
            background: var(--primary-bg);
            border-left: 3px solid var(--primary);
            padding: 14px 16px;
            border-radius: var(--radius-sm);
            font-size: 13px;
            color: var(--gray-600);
            margin-bottom: 24px;
            line-height: 1.6;
        }

        .info-box strong {
            color: var(--gray-800);
        }

        /* Checkbox */
        .form-check {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 24px;
        }

        .form-check input[type="checkbox"] {
            width: 18px;
            height: 18px;
            accent-color: var(--primary);
            cursor: pointer;
            flex-shrink: 0;
        }

        .form-check label {
            font-size: 13px;
            color: var(--gray-600);
            cursor: pointer;
            line-height: 1.4;
        }

        /* Responsive */
        @media (min-width: 1024px) {
            .auth-brand {
                display: flex;
            }
        }

        @media (max-width: 480px) {
            .auth-card {
                padding: 32px 24px;
                border-radius: var(--radius-lg);
            }

            .auth-header h1 {
                font-size: 22px;
            }

            .form-row {
                grid-template-columns: 1fr;
                gap: 0;
            }
        }

        /* Subtle entrance animation */
        @keyframes slideUp {
            from { opacity: 0; transform: translateY(16px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .auth-card {
            animation: slideUp 0.4s ease-out;
        }
    </style>
</head>
<body>
<?php
}

function renderAuthBrand(): void {
?>
    <div class="auth-brand">
        <div class="auth-brand-content">
            <h1>Analytics<br>Dashboard</h1>
            <p>Powerful visitor analytics, bot protection, and traffic management — all in one place.</p>
            <div class="auth-brand-features">
                <div class="auth-brand-feature">
                    <div class="auth-brand-feature-icon">📊</div>
                    <span>Real-time visitor tracking & insights</span>
                </div>
                <div class="auth-brand-feature">
                    <div class="auth-brand-feature-icon">🛡️</div>
                    <span>Advanced bot detection & blocking</span>
                </div>
                <div class="auth-brand-feature">
                    <div class="auth-brand-feature-icon">🌍</div>
                    <span>Geo-based access control</span>
                </div>
                <div class="auth-brand-feature">
                    <div class="auth-brand-feature-icon">⚡</div>
                    <span>Smart redirect management</span>
                </div>
            </div>
        </div>
    </div>
<?php
}

function renderAuthLogo(): void {
?>
    <div class="auth-logo">
        <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
            <path d="M3 13h2v8H3v-8zm4-4h2v12H7V9zm4-4h2v16h-2V5zm4 6h2v10h-2V11zm4-3h2v13h-2V8z"/>
        </svg>
    </div>
<?php
}

function renderPasswordToggleSVG(): void {
?>
    <svg class="eye-open" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/><circle cx="12" cy="12" r="3"/></svg>
    <svg class="eye-closed" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="display:none"><path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94"/><path d="M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19"/><line x1="1" y1="1" x2="23" y2="23"/></svg>
<?php
}

function renderAuthFooter(): void {
?>
    </body>
    </html>
<?php
}
